import re
import ast
import matplotlib.pyplot as plt

# ——— CONFIG ———
log_path = "wilson_verbose.log"   # or wherever you redirected your console output
gauge   = "U1"                    # gauge channel to inspect
Ls      = [6, 8, 10, 12]          # lattice sizes you want to compare
# ——————————

# Regex to catch your debug lines
pattern = re.compile(
    r"\[DEBUG\] raw ⟨W⟩ for L=(\d+), gauge=" + re.escape(gauge) + r":\s*(\[[^\]]+\])"
)

data = {}  # L -> list of floats

with open(log_path) as f:
    for line in f:
        m = pattern.search(line)
        if not m:
            continue
        L = int(m.group(1))
        if L not in Ls:
            continue
        vals = ast.literal_eval(m.group(2))  # safely parse the Python list
        data.setdefault(L, []).append(vals)

# For simplicity, take the first occurrence per L:
for L in Ls:
    if L in data:
        data[L] = data[L][0]    
    else:
        raise ValueError(f"No debug ⟨W⟩ line found for L={L}")

# Plotting
plt.figure(figsize=(6,4))
for L, W in data.items():
    loop_sizes = list(range(1, len(W)+1))  # assuming W[i] corresponds to the i×i loop
    plt.plot(loop_sizes, W, label=f"L={L}")
plt.xlabel("Loop size")
plt.ylabel("⟨W⟩")
plt.title(f"U(1) Wilson-loop averages for different L")
plt.legend()
plt.tight_layout()
plt.show()
